@extends('layouts.user')
@push('css')
    <style>
        body {
            font-size: 15px;
        }

        .property-img1 img {
            width: 400px;
            height: 225px;
            object-fit: cover;
        }

        @media (min-width: 576px) {
            .img {
                width: auto;
                height: auto;
            }
        }

        #recent-search-list li {
            display: flex;
            justify-content: space-between;
            align-items: center;
            /* no border */
        }

        #recent-search-list li span {
            flex: 1 1 auto;
            min-width: 0;
            /* important for truncation */
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
            margin-right: 10px;
        }

        #recent-search-list li a.redo-search-icon {
            flex: 0 0 auto;
            padding: 4px 8px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        @media (max-width: 576px) {
            #recent-search-list li span {
                font-size: 14px;
                white-space: nowrap;
            }

            #recent-search-list li a.redo-search-icon {
                padding: 2px 6px;
                font-size: 16px;
            }
        }

        .dashboard-stat-content {
            position: absolute;
            left: 10px;
            top: 50%;
            transform: translateY(-50%);
        }
    </style>
@endpush
@section('title')
    <!-- ============================ Page Title Start================================== -->
    <div class="page-title m-0">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 col-md-12">
                    <h2 class="ipt-title">@lang('Welcome')!</h2>
                    <span class="ipn-subtitle">@lang('Welcome To Your Account')</span>
                </div>
            </div>
        </div>
    </div>
    <!-- ============================ Page Title End ================================== -->
@endsection
@section('content')
    <!-- ============================ User Dashboard ================================== -->
    @if (session('message'))
        <div class="alert alert-success">
            {{ session('message') }}
        </div>
    @endif

    @if (auth()->check() && !auth()->user()->hasVerifiedEmail())
        <div class="modal fade" id="verifyEmailModal" tabindex="-1" role="dialog" aria-labelledby="verifyEmailLabel"
            aria-hidden="true" data-backdrop="static" data-keyboard="false">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content border shadow-lg rounded">
                    <div class="modal-header bg-success text-dark">
                        <h5 class="modal-title fw-bold" id="verifyEmailLabel">Email Verification Required</h5>
                    </div>
                    <div class="modal-body">
                        <p id="verificationPrompt" class="mb-3">
                            Your email address is not verified. Please click below button to verify your email.
                        </p>

                        <div id="verificationMessage"></div>

                        {{-- ✅ SEND button: shown by default --}}
                        <form id="sendVerificationForm">
                            @csrf
                            <button type="submit" class="btn btn-primary btn-sm" id="sendBtn">
                                Send Verification Email
                            </button>
                        </form>
                    </div>
                    <div class="modal-footer">
                        <button id="remindMeBtn" type="button" class="btn btn-outline-secondary btn-sm"
                            data-dismiss="modal">
                            Remind Me Later
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <script>
            document.addEventListener("DOMContentLoaded", function() {
                setTimeout(() => {
                    $('#verifyEmailModal').modal('show');
                }, 300);

                const form = document.getElementById('sendVerificationForm');
                const messageDiv = document.getElementById('verificationMessage');
                const remindBtn = document.getElementById('remindMeBtn');
                const promptText = document.getElementById('verificationPrompt');
                const sendBtn = document.getElementById('sendBtn');

                remindBtn.addEventListener('click', function() {
                    $('#verifyEmailModal').modal('hide');
                });

                form.addEventListener('submit', function(e) {
                    e.preventDefault();

                    messageDiv.innerHTML = `
            <div class="alert alert-success p-2 mt-3" role="alert">
                ✅ Sending verification email...
            </div>`;

                    fetch("{{ route('verification.send') }}", {
                            method: "POST",
                            headers: {
                                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                                'Accept': 'application/json'
                            },
                        })
                        .then(response => {
                            if (response.ok) {
                                promptText.style.display = 'none';

                                messageDiv.innerHTML = `
                    <div class="alert alert-success p-2 mt-3" role="alert">
                        Please check your inbox for the verification link.
                    </div>`;

                                // ✅ Update button text
                                sendBtn.textContent = 'Resend Verification Email';

                                remindBtn.style.display = 'inline-block';
                            } else {
                                return response.json().then(data => {
                                    throw new Error(data.message || "Something went wrong.");
                                });
                            }
                        })
                        .catch(error => {
                            messageDiv.innerHTML = `
                <div class="alert alert-danger p-2 mt-3" role="alert">
                    ⚠️ ${error.message}
                </div>`;
                        });
                });
            });
        </script>
    @endif

    <div class="dashboard-wraper">
        <div class="mb-3">
            <p>@lang('Your Current Package'): <span
                    class="pc-title theme-cl">{{ auth()->user()->plan != null ? auth()->user()->plan->title . '(' . Carbon\Carbon::parse(auth()->user()->plan_end_date)->format('d-m-Y') . ')' : 'N/A' }}</span>
            </p>
            @if (auth()->user()->plan == null)
                <!--<p class="text-danger">@lang('To be an agent, you should under a subscription package.')</p>-->
            @endif
        </div>
        <h6>My Activity</h6>
        <div class="row g-3">
            <div class="col-lg-3 col-md-6 col-sm-12">
                <div class="dashboard-stat mb-0 widget-1 text-center pt-2 clickable-box" data-target="contacted-data">
                    <div class="dashboard-stat-content">
                        <i class="ti-user"></i>
                        <span>@lang('Contacted Properties') : </span>
                        {{ $contactsCount ?? 0 }}
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12">
                <div class="dashboard-stat mb-0 widget-2 text-center pt-2 clickable-box" data-target="seen-data">
                    <div class="dashboard-stat-content">
                        <i class="ti-eye"></i>
                        <span>@lang('Seen Properties') : </span>
                        {{ $seenPropertyCount ?? 0 }}
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12">
                <div class="dashboard-stat mb-0 widget-3 text-center pt-2 clickable-box" data-target="saved-data">
                    <div class="dashboard-stat-content">
                        <i class="lni-heart-filled"></i>
                        <span>@lang('Wishlisted Properties') : </span>
                        {{ $savedPropertyCount ?? 0 }}
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12">
                <div class="dashboard-stat mb-0 widget-4 text-center pt-2 clickable-box" data-target="recent-searches-data">
                    <div class="dashboard-stat-content">
                        <i class="ti-search"></i>
                        <span>Recent Searches</span>
                    </div>
                </div>
            </div>
        </div>
      <div class="mb-3 filter-btn-group btn-group btn-group-toggle" data-toggle="buttons">
    <label class="btn btn-secondary btn-sm rounded border-secondary {{ !request('looking_for') ? 'active' : '' }}">
        <input name="looking_for" type="radio" value="" autocomplete="off" {{ !request('looking_for') ? 'checked' : '' }}>@lang('All')
    </label>
    <label class="btn btn-secondary btn-sm rounded border-secondary {{ request('looking_for') == 'for_sell' ? 'active' : '' }}">
        <input name="looking_for" type="radio" value="for_sell" autocomplete="off" {{ request('looking_for') == 'for_sell' ? 'checked' : '' }}>@lang('For Sell')
    </label>
    <label class="btn btn-secondary btn-sm rounded border-secondary {{ request('looking_for') == 'for_rent' ? 'active' : '' }}">
        <input name="looking_for" type="radio" value="for_rent" autocomplete="off" {{ request('looking_for') == 'for_rent' ? 'checked' : '' }}>@lang('For Rent')
    </label>
    <label class="btn btn-secondary btn-sm rounded border-secondary {{ request('looking_for') == 'for_pg' ? 'active' : '' }}">
        <input name="looking_for" type="radio" value="for_pg" autocomplete="off" {{ request('looking_for') == 'for_pg' ? 'checked' : '' }}>@lang('For PG')
    </label>
</div>
       
        <!-- Data Display Section -->
        <div class="data-container">
            <div id="contacted-data" class="data-content" style="display: block;">
                <h4>@lang('Contacted Properties')</h4>
                @foreach ($contacts as $contact)
                    @php
                        $property = $contact->property;
                        $routes = [
                            'for_pg' => 'pg.details',
                            'for_rent' => 'rent.details',
                            'for_sell' => 'buy.details',
                            'plot' => 'plot.details',
                            'commercial' => 'commercial.details',
                        ];

                        $propertyUrl = isset($routes[$property->looking_for])
                            ? route($routes[$property->looking_for], $property->slug)
                            : '#'; // fallback
                    @endphp
                    <div class="col-lg-12 col-md-12">
                        <a href="{{ $propertyUrl }}" target="_blank">
                            <div
                                class="property-card d-flex flex-wrap flex-md-nowrap shadow-lg rounded-3 overflow-hidden position-relative pt-2">
                                <div class="property-img1 position-relative ">
                                    <img src="{{ asset('assets/images/' . $property->photo) }}"
                                        class="img-fluid img"alt="Property Image">
                                    <!-- Wishlist Icon -->
                                    <div class="wishlist-icon position-absolute top-0 end-0 p-2">
                                        <a href="javascript:void(0);" id="wishList"
                                            class="{{ $property->checkFavourite(auth()->id(), $property->id) ? 'like-bitt' : '' }} add-to-favorite"
                                            data-property="{{ $property->id }}" data-user="{{ auth()->id() }}"
                                            data-bs-toggle="tooltip" data-original-title="Add To Favorites">
                                            <i class="lni-heart-filled"></i>
                                        </a>
                                    </div>

                                    <!-- Rating -->
                                    @if ($property->reviews->count() > 0)
                                        <div
                                            class="listing-rating position-absolute bottom-0 start-0 p-2 bg-dark text-white rounded">
                                            @php
                                                $review = $property->reviews->sum('rate') / $property->reviews->count();
                                            @endphp
                                            @for ($i = 1; $i <= $review; $i++)
                                                <i class="ti-star filled text-warning"></i>
                                            @endfor
                                            @if (is_float($review))
                                                <i class="ti-star text-warning"></i>
                                            @endif
                                        </div>
                                    @endif
                                    <!-- Property Type Label -->
                                    <span
                                        class="property-type position-absolute top-0 start-0 p-2 bg-primary text-white rounded">
                                        @if ($property->looking_for == 'for_rent')
                                            {{ __('For Rent') }}
                                        @elseif ($property->looking_for == 'for_sell')
                                            {{ __('For Sell') }}
                                        @elseif ($property->looking_for == 'for_pg')
                                            {{ __('For PG') }}
                                        @else
                                            {{ __('Property') }}
                                        @endif
                                    </span>
                                </div>
                                <!-- Right Side: Property Details -->
                                <div class="property-details px-4 flex-grow-1" style="width: 50%;">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <p class="property-price mt-4" style="color: #3936f8; font-weight: bold;">
                                            {{ showAmount($property->price) ?? '' }}</p>
                                        <!-- Share Button -->
                                        <svg class="mt-2" xmlns="http://www.w3.org/2000/svg" x="0px" y="0px"
                                            width="24" height="22" viewBox="0 0 30 30" style="fill:#474646;"
                                            onclick="toggleShareOptions(event, '{{ $property->id }}')">
                                            <path
                                                d="M 23 3 C 20.791 3 19 4.791 19 7 C 19 7.2869826 19.034351 7.5660754 19.091797 7.8359375L 10 12.380859 C 9.2667379 11.541629 8.2018825 11 7 11 C 4.791 11 3 12.791 3 15 C 3 17.209 4.791 19 7 19 C 8.2018825 19 9.2667379 18.458371 10 17.619141 L 19.091797 22.164062 C 19.034351 22.433925 19 22.713017 19 23 C 19 25.209 20.791 27 23 27 C 25.209 27 27 25.209 27 23 C 27 20.791 25.209 19 23 19 C 21.798117 19 20.733262 19.541629 20 20.380859 L 10.908203 15.835938 C 10.965649 15.566075 11 15.286983 11 15 C 11 14.713017 10.965649 14.433925 10.908203 14.164062 L 20 9.6191406 C 20.733262 10.458371 21.798117 11 23 11 C 25.209 11 27 9.209 27 7 C 27 4.791 25.209 3 23 3 z">
                                            </path>
                                        </svg>
                                        <!-- Share Options -->
                                        <div class="share-options" id="shareOptions-{{ $property->id }}"
                                            style="display: none;">
                                            <a href="{{ $propertyUrl }}" onclick="share('whatsapp', '#')"><i
                                                    class="fa-brands fa-whatsapp"></i>&nbsp;&nbsp; WhatsApp &nbsp;</a>
                                            <a href="{{ $propertyUrl }}" onclick="copyLink('#')"><i
                                                    class="ti-link"></i>&nbsp;&nbsp;
                                                Copy Link &nbsp;</a>
                                            <a href="{{ $propertyUrl }}" onclick="share('instagram', '#')"><i
                                                    class="ti-instagram"></i>&nbsp;&nbsp; Instagram &nbsp;</a>
                                            <a href="{{ $propertyUrl }}" onclick="share('facebook', '#')"><i
                                                    class="ti-facebook"></i>&nbsp;&nbsp; Facebook &nbsp;</a>
                                            <a href="{{ $propertyUrl }}" onclick="share('twitter', '#')"><i
                                                    class="fa-brands fa-x"></i>&nbsp;&nbsp; Twitter &nbsp;</a>
                                            <a href="{{ $propertyUrl }}" onclick="share('linkedin', '#')"><i
                                                    class="ti-linkedin"></i>&nbsp;&nbsp; Linkedin &nbsp;</a>
                                        </div>
                                    </div>
                                    <div class="d-flex align-items-center justify-content-between mb-2">
                                        <div>
                                            <h5 class="property-title mt-2">{{ $property->name ?? '' }}</h5>
                                            <p class="property-location text-muted" style="font-size: 11px">
                                                <i class="ti-location-pin"></i> {{ $property->locality ?? '' }},
                                                {{ $property->location->name ?? '' }}
                                            </p>
                                        </div>
                                        <div class="ms-auto text-end" style="font-size: 11px">
                                            <span>{{ $property->user->name ?? '' }}</span><br>
                                            <span class="text-muted">{{ $property->user->user_type ?? '' }}</span><br>
                                            <span class="text-muted"> +91{{ $property->user->phone ?? '' }}</span>
                                        </div>
                                    </div>
                                    <!-- Features -->
                                    @php
                                        $features = [];

                                        if ($property->no_of_bhk) {
                                            $features[] =
                                                '<p><i class="ti-home"></i> BHK <br>&nbsp;' .
                                                $property->no_of_bhk .
                                                '</p>';
                                        }
                                        if (
                                            $property->construction_status == 'under-construction' &&
                                            $property->possession_date
                                        ) {
                                            $features[] =
                                                '<p><i class="fa-solid fa-calendar-alt"></i> Possession Date <br>&nbsp;' .
                                                $property->possession_date .
                                                '</p>';
                                        } elseif (
                                            $property->construction_status == 'ready-to-move' &&
                                            $property->property_age
                                        ) {
                                            $features[] =
                                                '<p><i class="fa-solid fa-clock"></i> Age Of Property <br>&nbsp;' .
                                                $property->property_age .
                                                ' Years</p>';
                                        }

                                        if ($property->construction_status) {
                                            $features[] =
                                                '<p><i class="fa-solid fa-building"></i> Construction Status <br>&nbsp;' .
                                                ucwords(str_replace('-', ' ', $property->construction_status)) .
                                                '</p>';
                                        }

                                        if ($property->carpet_area) {
                                            $features[] =
                                                '<p><i class="ti-ruler-pencil"></i> Carpet Area <br>&nbsp;' .
                                                $property->carpet_area .
                                                ' Sqft</p>';
                                        }

                                        if ($property->price_per_sqft) {
                                            $features[] =
                                                '<p><i class="fa-solid me-1">₹</i> Price Per Sqft <br>&nbsp;' .
                                                $property->price_per_sqft .
                                                ' Sqft</p>';
                                        }

                                        if ($property->plot_area) {
                                            $features[] =
                                                '<p><i class="bi bi-rulers"></i> Plot Area <br>&nbsp;<b>' .
                                                $property->plot_area .
                                                ' ' .
                                                $property->area_unit .
                                                '</b></p>';
                                        }

                                        if ($property->plot_length && $property->plot_width) {
                                            $features[] =
                                                '<p><i class="bi bi-clock-history"></i> Plot Dimensions <br>&nbsp;<b>' .
                                                ucfirst($property->plot_length . ' X ' . $property->plot_width) .
                                                '</b></p>';
                                        }

                                        if ($property->floors_allowed) {
                                            $features[] =
                                                '<p><i class="bi bi-building"></i> Floors Allowed <br>&nbsp;<b>' .
                                                $property->floors_allowed .
                                                ' ' .
                                                ($property->floors_allowed == 1 ? 'Floor' : 'Floors') .
                                                '</b></p>';
                                        }

                                        if ($property->open_sides) {
                                            $features[] =
                                                '<p><i class="bi bi-box-arrow-in-left"></i> No. Of Open Sides <br>&nbsp;<b>' .
                                                $property->open_sides .
                                                ' ' .
                                                ($property->open_sides == 1 ? 'Side' : 'Sides') .
                                                '</b></p>';
                                        }

                                        $features = array_slice($features, 0, 3); // Show only top 4 features
                                    @endphp

                                    @if (count($features) > 0)
                                        <div class="property-features d-flex flex-wrap justify-content-between text-muted mt-3"
                                            style="font-size: 11px">
                                            @foreach ($features as $feature)
                                                {!! $feature !!}
                                            @endforeach
                                        </div>
                                    @endif

                                </div>
                            </div>
                        </a>
                    </div>
                @endforeach
            </div>
            <div id="seen-data" class="data-content" style="display: none;">
                <h4>@lang('Seen Properties')</h4>
                @if (empty($seenProperties))
                    No data Available
                @else
                    @foreach ($seenProperties as $sProperty)
                        @php
                            $property = $sProperty->property;
                            $routes = [
                                'for_pg' => 'pg.details',
                                'for_rent' => 'rent.details',
                                'for_sell' => 'buy.details',
                                'plot' => 'plot.details',
                                'commercial' => 'commercial.details',
                            ];
                            $propertyUrl = isset($routes[$property->looking_for])
                                ? route($routes[$property->looking_for], $property->slug)
                                : '#';
                            $features = [];
                            if ($property->no_of_bhk) {
                                $features[] =
                                    '<p><i class="ti-home"></i> BHK <br>&nbsp;' .
                                    $property->no_of_bhk .
                                    '</p>';
                            }
                            if (
                                $property->construction_status == 'under-construction' &&
                                $property->possession_date
                            ) {
                                $features[] =
                                    '<p><i class="fa-solid fa-calendar-alt"></i> Possession Date <br>&nbsp;' .
                                    $property->possession_date .
                                    '</p>';
                            } elseif (
                                $property->construction_status == 'ready-to-move' &&
                                $property->property_age
                            ) {
                                $features[] =
                                    '<p><i class="fa-solid fa-clock"></i> Age Of Property <br>&nbsp;' .
                                    $property->property_age .
                                    ' Years</p>';
                            }
                            if ($property->construction_status) {
                                $features[] =
                                    '<p><i class="fa-solid fa-building"></i> Construction Status <br>&nbsp;' .
                                    ucwords(str_replace('-', ' ', $property->construction_status)) .
                                    '</p>';
                            }
                            if ($property->carpet_area) {
                                $features[] =
                                    '<p><i class="ti-ruler-pencil"></i> Carpet Area <br>&nbsp;' .
                                    $property->carpet_area .
                                    ' Sqft</p>';
                            }
                            if ($property->price_per_sqft) {
                                $features[] =
                                    '<p><i class="fa-solid me-1">₹</i> Price Per Sqft <br>&nbsp;' .
                                    $property->price_per_sqft .
                                    ' Sqft</p>';
                            }
                            if ($property->plot_area) {
                                $features[] =
                                    '<p><i class="bi bi-rulers"></i> Plot Area <br>&nbsp;<b>' .
                                    $property->plot_area .
                                    ' ' .
                                    $property->area_unit .
                                    '</b></p>';
                            }
                            if ($property->plot_length && $property->plot_width) {
                                $features[] =
                                    '<p><i class="bi bi-clock-history"></i> Plot Dimensions <br>&nbsp;<b>' .
                                    ucfirst($property->plot_length . ' X ' . $property->plot_width) .
                                    '</b></p>';
                            }
                            if ($property->floors_allowed) {
                                $features[] =
                                    '<p><i class="bi bi-building"></i> Floors Allowed <br>&nbsp;<b>' .
                                    $property->floors_allowed .
                                    ' ' .
                                    ($property->floors_allowed == 1 ? 'Floor' : 'Floors') .
                                    '</b></p>';
                            }
                            if ($property->open_sides) {
                                $features[] =
                                    '<p><i class="bi bi-box-arrow-in-left"></i> No. Of Open Sides <br>&nbsp;<b>' .
                                    $property->open_sides .
                                    ' ' .
                                    ($property->open_sides == 1 ? 'Side' : 'Sides') .
                                    '</b></p>';
                            }
                            $features = array_slice($features, 0, 3);
                        @endphp
                        <div class="col-lg-12 col-md-12">
                            <a href="{{ $propertyUrl }}" target="_blank">
                                <div
                                    class="property-card d-flex flex-wrap flex-md-nowrap shadow-lg rounded-3 overflow-hidden position-relative pt-2">
                                    <div class="property-img1 position-relative ">
                                        <img src="{{ asset('assets/images/' . $property->photo) }}" class="img-fluid img"
                                            alt="Property Image">
                                        <!-- Wishlist Icon -->
                                        <div class="wishlist-icon position-absolute top-0 end-0 p-2">
                                            <a href="JavaScript:Void(0);" id="wishList"
                                                class="{{ $property->checkFavourite(auth()->id(), $property->id) ? 'like-bitt' : '' }} add-to-favorite"
                                                data-property="{{ $property->id }}" data-user="{{ auth()->id() }}"
                                                data-bs-toggle="tooltip" data-original-title="Add To Favorites">
                                                <i class="lni-heart-filled"></i>
                                            </a>
                                        </div>
                                        <!-- Rating -->
                                        @if ($property->reviews->count() > 0)
                                            <div
                                                class="listing-rating position-absolute bottom-0 start-0 p-2 bg-dark text-white rounded">
                                                @php
                                                    $review =
                                                        $property->reviews->sum('rate') / $property->reviews->count();
                                                @endphp
                                                @for ($i = 1; $i <= $review; $i++)
                                                    <i class="ti-star filled text-warning"></i>
                                                @endfor
                                                @if (is_float($review))
                                                    <i class="ti-star text-warning"></i>
                                                @endif
                                            </div>
                                        @endif
                                        <!-- Property Type Label -->
                                        <span
                                            class="property-type position-absolute top-0 start-0 p-2 bg-primary text-white rounded">
                                            @if ($property->looking_for == 'for_rent')
                                                {{ __('For Rent') }}
                                            @elseif ($property->looking_for == 'for_sell')
                                                {{ __('For Sell') }}
                                            @elseif ($property->looking_for == 'for_pg')
                                                {{ __('For PG') }}
                                            @else
                                                {{ __('Property') }}
                                            @endif
                                        </span>
                                    </div>
                                    <!-- Right Side: Property Details -->
                                    <div class="property-details px-4 flex-grow-1" style="width: 50%;">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <p class="property-price mt-4" style="color: #3936f8; font-weight: bold;">
                                                {{ showAmount($property->price) }}</p>
                                            <!-- Share Button -->
                                            <svg class="mt-2" xmlns="http://www.w3.org/2000/svg" x="0px" y="0px"
                                                width="24" height="22" viewBox="0 0 30 30" style="fill:#474646;"
                                                onclick="toggleShareOptions(event, '{{ $property->id }}')">
                                                <path
                                                    d="M 23 3 C 20.791 3 19 4.791 19 7 C 19 7.2869826 19.034351 7.5660754 19.091797 7.8359375L 10 12.380859 C 9.2667379 11.541629 8.2018825 11 7 11 C 4.791 11 3 12.791 3 15 C 3 17.209 4.791 19 7 19 C 8.2018825 19 9.2667379 18.458371 10 17.619141 L 19.091797 22.164062 C 19.034351 22.433925 19 22.713017 19 23 C 19 25.209 20.791 27 23 27 C 25.209 27 27 25.209 27 23 C 27 20.791 25.209 19 23 19 C 21.798117 19 20.733262 19.541629 20 20.380859 L 10.908203 15.835938 C 10.965649 15.566075 11 15.286983 11 15 C 11 14.713017 10.965649 14.433925 10.908203 14.164062 L 20 9.6191406 C 20.733262 10.458371 21.798117 11 23 11 C 25.209 11 27 9.209 27 7 C 27 4.791 25.209 3 23 3 z">
                                                </path>
                                            </svg>
                                            <!-- Share Options -->
                                            <div class="share-options" id="shareOptions-{{ $property->id }}"
                                                style="display: none;">
                                                <a href="{{ $propertyUrl }}" onclick="share('whatsapp', '#')"><i
                                                        class="fa-brands fa-whatsapp"></i>&nbsp;&nbsp; WhatsApp &nbsp;</a>
                                                <a href="{{ $propertyUrl }}" onclick="copyLink('#')"><i
                                                        class="ti-link"></i>&nbsp;&nbsp; Copy Link &nbsp;</a>
                                                <a href="{{ $propertyUrl }}" onclick="share('instagram', '#')"><i
                                                        class="ti-instagram"></i>&nbsp;&nbsp; Instagram &nbsp;</a>
                                                <a href="{{ $propertyUrl }}" onclick="share('facebook', '#')"><i
                                                        class="ti-facebook"></i>&nbsp;&nbsp; Facebook &nbsp;</a>
                                                <a href="{{ $propertyUrl }}" onclick="share('twitter', '#')"><i
                                                        class="fa-brands fa-x"></i>&nbsp;&nbsp; Twitter &nbsp;</a>
                                                <a href="{{ $propertyUrl }}" onclick="share('linkedin', '#')"><i
                                                        class="ti-linkedin"></i>&nbsp;&nbsp; Linkedin &nbsp;</a>
                                            </div>
                                        </div>
                                        <div class="d-flex align-items-center justify-content-between mb-2">
                                            <div>
                                                <h5 class="property-title mt-2">{{ $property->name ?? '' }}</h5>
                                                <p class="property-location text-muted" style="font-size: 11px">
                                                    <i class="ti-location-pin"></i> {{ $property->locality ?? '' }},
                                                    {{ $property->location->name ?? '' }}
                                                </p>
                                            </div>
                                            <div class="ms-auto text-end" style="font-size: 11px">
                                                <span>{{ $property->user->name ?? '' }}</span><br>
                                                <span class="text-muted">{{ $property->user->user_type ?? '' }}</span><br>
                                                <span class="text-muted"> +91{{ $property->user->phone ?? '' }}</span>
                                            </div>
                                        </div>
                                        <!-- Features -->

                                        @if (count($features) > 0)
                                            <div class="property-features d-flex flex-wrap justify-content-between text-muted mt-3"
                                                style="font-size: 11px">
                                                @foreach ($features as $feature)
                                                    {!! $feature !!}
                                                @endforeach
                                            </div>
                                        @endif

                                    </div>
                                </div>
                            </a>
                        </div>
                    @endforeach
                @endif
            </div>
            <div id="saved-data" class="data-content" style="display: none;">
                <h4>@lang('Saved Properties')</h4>
                @if (empty($savedProperty))
                    No data Available
                @else
                    @foreach ($savedProperty as $contact)
                        @php
                            $property = $contact->property;
                            $routes = [
                                'for_pg' => 'pg.details',
                                'for_rent' => 'rent.details',
                                'for_sell' => 'buy.details',
                                'plot' => 'plot.details',
                                'commercial' => 'commercial.details',
                            ];
                            $propertyUrl = isset($routes[$property->looking_for])
                                ? route($routes[$property->looking_for], $property->slug)
                                : '#';
                            $features = [];
                            if ($property->no_of_bhk) {
                                $features[] =
                                    '<p><i class="ti-home"></i> BHK <br>&nbsp;' .
                                    $property->no_of_bhk .
                                    '</p>';
                            }
                            if (
                                $property->construction_status == 'under-construction' &&
                                $property->possession_date
                            ) {
                                $features[] =
                                    '<p><i class="fa-solid fa-calendar-alt"></i> Possession Date <br>&nbsp;' .
                                    $property->possession_date .
                                    '</p>';
                            } elseif (
                                $property->construction_status == 'ready-to-move' &&
                                $property->property_age
                            ) {
                                $features[] =
                                    '<p><i class="fa-solid fa-clock"></i> Age Of Property <br>&nbsp;' .
                                    $property->property_age .
                                    ' Years</p>';
                            }
                            if ($property->construction_status) {
                                $features[] =
                                    '<p><i class="fa-solid fa-building"></i> Construction Status <br>&nbsp;' .
                                    ucwords(str_replace('-', ' ', $property->construction_status)) .
                                    '</p>';
                            }
                            if ($property->carpet_area) {
                                $features[] =
                                    '<p><i class="ti-ruler-pencil"></i> Carpet Area <br>&nbsp;' .
                                    $property->carpet_area .
                                    ' Sqft</p>';
                            }
                            if ($property->price_per_sqft) {
                                $features[] =
                                    '<p><i class="fa-solid me-1">₹</i> Price Per Sqft <br>&nbsp;' .
                                    $property->price_per_sqft .
                                    ' Sqft</p>';
                            }
                            if ($property->plot_area) {
                                $features[] =
                                    '<p><i class="bi bi-rulers"></i> Plot Area <br>&nbsp;<b>' .
                                    $property->plot_area .
                                    ' ' .
                                    $property->area_unit .
                                    '</b></p>';
                            }
                            if ($property->plot_length && $property->plot_width) {
                                $features[] =
                                    '<p><i class="bi bi-clock-history"></i> Plot Dimensions <br>&nbsp;<b>' .
                                    ucfirst($property->plot_length . ' X ' . $property->plot_width) .
                                    '</b></p>';
                            }
                            if ($property->floors_allowed) {
                                $features[] =
                                    '<p><i class="bi bi-building"></i> Floors Allowed <br>&nbsp;<b>' .
                                    $property->floors_allowed .
                                    ' ' .
                                    ($property->floors_allowed == 1 ? 'Floor' : 'Floors') .
                                    '</b></p>';
                            }
                            if ($property->open_sides) {
                                $features[] =
                                    '<p><i class="bi bi-box-arrow-in-left"></i> No. Of Open Sides <br>&nbsp;<b>' .
                                    $property->open_sides .
                                    ' ' .
                                    ($property->open_sides == 1 ? 'Side' : 'Sides') .
                                    '</b></p>';
                            }
                            $features = array_slice($features, 0, 3);
                        @endphp
                        <div class="col-lg-12 col-md-12">
                            <a href="{{ $propertyUrl }}" target="_blank">
                                <div
                                    class="property-card d-flex flex-wrap flex-md-nowrap shadow-lg rounded-3 overflow-hidden position-relative pt-2">
                                    <div class="property-img1 position-relative ">
                                        <img src="{{ asset('assets/images/' . $property->photo) }}" class="img-fluid img"
                                            alt="Property Image">
                                        <!-- Wishlist Icon -->
                                        <div class="wishlist-icon position-absolute top-0 end-0 p-2">
                                            <a href="JavaScript:Void(0);" id="wishList"
                                                class="{{ $property->checkFavourite(auth()->id(), $property->id) ? 'like-bitt' : '' }} add-to-favorite"
                                                data-property="{{ $property->id }}" data-user="{{ auth()->id() }}"
                                                data-bs-toggle="tooltip" data-original-title="Add To Favorites">
                                                <i class="lni-heart-filled"></i>
                                            </a>
                                        </div>
                                        <!-- Rating -->
                                        @if ($property->reviews->count() > 0)
                                            <div
                                                class="listing-rating position-absolute bottom-0 start-0 p-2 bg-dark text-white rounded">
                                                @php
                                                    $review =
                                                        $property->reviews->sum('rate') / $property->reviews->count();
                                                @endphp
                                                @for ($i = 1; $i <= $review; $i++)
                                                    <i class="ti-star filled text-warning"></i>
                                                @endfor
                                                @if (is_float($review))
                                                    <i class="ti-star text-warning"></i>
                                                @endif
                                            </div>
                                        @endif
                                        <!-- Property Type Label -->
                                        <span
                                            class="property-type position-absolute top-0 start-0 p-2 bg-primary text-white rounded">
                                            @if ($property->looking_for == 'for_rent')
                                                {{ __('For Rent') }}
                                            @elseif ($property->looking_for == 'for_sell')
                                                {{ __('For Sell') }}
                                            @elseif ($property->looking_for == 'for_pg')
                                                {{ __('For PG') }}
                                            @else
                                                {{ __('Property') }}
                                            @endif
                                        </span>
                                    </div>
                                    <!-- Right Side: Property Details -->
                                    <div class="property-details px-4 flex-grow-1" style="width: 50%;">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <p class="property-price mt-4" style="color: #3936f8; font-weight: bold;">
                                                {{ showAmount($property->price) }}</p>
                                            <!-- Share Button -->
                                            <svg class="mt-2" xmlns="http://www.w3.org/2000/svg" x="0px" y="0px"
                                                width="24" height="22" viewBox="0 0 30 30" style="fill:#474646;"
                                                onclick="toggleShareOptions(event, '{{ $property->id }}')">
                                                <path
                                                    d="M 23 3 C 20.791 3 19 4.791 19 7 C 19 7.2869826 19.034351 7.5660754 19.091797 7.8359375L 10 12.380859 C 9.2667379 11.541629 8.2018825 11 7 11 C 4.791 11 3 12.791 3 15 C 3 17.209 4.791 19 7 19 C 8.2018825 19 9.2667379 18.458371 10 17.619141 L 19.091797 22.164062 C 19.034351 22.433925 19 22.713017 19 23 C 19 25.209 20.791 27 23 27 C 25.209 27 27 25.209 27 23 C 27 20.791 25.209 19 23 19 C 21.798117 19 20.733262 19.541629 20 20.380859 L 10.908203 15.835938 C 10.965649 15.566075 11 15.286983 11 15 C 11 14.713017 10.965649 14.433925 10.908203 14.164062 L 20 9.6191406 C 20.733262 10.458371 21.798117 11 23 11 C 25.209 11 27 9.209 27 7 C 27 4.791 25.209 3 23 3 z">
                                                </path>
                                            </svg>
                                            <!-- Share Options -->
                                            <div class="share-options" id="shareOptions-{{ $property->id }}"
                                                style="display: none;">
                                                <a href="{{ $propertyUrl }}" onclick="share('whatsapp', '#')"><i
                                                        class="fa-brands fa-whatsapp"></i>&nbsp;&nbsp; WhatsApp &nbsp;</a>
                                                <a href="{{ $propertyUrl }}" onclick="copyLink('#')"><i
                                                        class="ti-link"></i>&nbsp;&nbsp; Copy Link &nbsp;</a>
                                                <a href="{{ $propertyUrl }}" onclick="share('instagram', '#')"><i
                                                        class="ti-instagram"></i>&nbsp;&nbsp; Instagram &nbsp;</a>
                                                <a href="{{ $propertyUrl }}" onclick="share('facebook', '#')"><i
                                                        class="ti-facebook"></i>&nbsp;&nbsp; Facebook &nbsp;</a>
                                                <a href="{{ $propertyUrl }}" onclick="share('twitter', '#')"><i
                                                        class="fa-brands fa-x"></i>&nbsp;&nbsp; Twitter &nbsp;</a>
                                                <a href="{{ $propertyUrl }}" onclick="share('linkedin', '#')"><i
                                                        class="ti-linkedin"></i>&nbsp;&nbsp; Linkedin &nbsp;</a>
                                            </div>
                                        </div>
                                        <div class="d-flex align-items-center justify-content-between mb-2">
                                            <div>
                                                <h5 class="property-title mt-2">{{ $property->name }}</h5>
                                                <p class="property-location text-muted">
                                                    <i class="ti-location-pin"></i> {{ $property->locality }},
                                                    {{ $property->location->name }}
                                                </p>
                                            </div>
                                            <div class="ms-auto text-end">
                                                <span>{{ $property->user->name }}</span><br>
                                                <span class="text-muted">{{ $property->user->user_type }}</span><br>
                                                <span class="text-muted"> +91{{ $property->user->phone }}</span>
                                            </div>
                                        </div>
                                        <!-- Features -->
                                        @if (count($features) > 0)
                                            <div class="property-features d-flex flex-wrap justify-content-between text-muted mt-3"
                                                style="font-size: 11px">
                                                @foreach ($features as $feature)
                                                    {!! $feature !!}
                                                @endforeach
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </a>
                        </div>
                    @endforeach
                @endif
            </div>
            <div id="recent-searches-data" class="data-content  mt-3 " style="display: none;">
                <h4>@lang('Recent Searches')</h4>
                <button id="clear-history" class="btn btn-dark btn-sm mb-2">Clear History</button>
                <div id="recent-searches">
                    <ul id="recent-search-list"></ul>
                </div>
            </div>
        </div>
    </div>
    <div class="dashboard-wraper">
        <div class="row">
            <div class="dashboard--content-item">
                <div class="row gy-4">
                    <div class="col-md-12">
                        <div class="dashboard--content-item">
                            <h5 class="dashboard-title">@lang('Referral URL')</h5>
                            <div class="dashboard-refer">
                                <div class="input-group input--group">
                                    <input type="text" class="form-control form--control" readonly
                                        value="{{ url('/') . '?reff=' . $user->affilate_code }}" id="cronjobURL">
                                    <button class="input-group-text px-3 btn--primary border-0" type="button"
                                        id="copyBoard" onclick="myFunction()">
                                        <i class="far fa-copy"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="dashboard--content-item">
                <div class="table-responsive table--mobile-lg">
                    <table class="table bg--body">
                        <thead>
                            <tr>
                                <th>@lang('No')</th>
                                <th>@lang('Type')</th>
                                <th>@lang('Txnid')</th>
                                <th>@lang('Amount')</th>
                                <th>@lang('Date')</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if (count($transactions) == 0)
                                <tr>
                                    <td colspan="12">
                                        <p class="text-center m-0 py-2">{{ __('No Data Found') }}</p>
                                    </td>
                                </tr>
                            @else
                                @foreach ($transactions as $key => $property)
                                    <tr>
                                        <td data-label="@lang('No')">
                                            <div>
                                                <span class="text-muted">{{ $loop->iteration }}</span>
                                            </div>
                                        </td>
                                        <td data-label="@lang('Type')">
                                            <div>
                                                {{ strtoupper($property->type) }}
                                            </div>
                                        </td>
                                        <td data-label="@lang('Txnid')">
                                            <div>
                                                {{ $property->txnid }}
                                            </div>
                                        </td>
                                        <td data-label="@lang('Amount')">
                                            <div>
                                                <p class="text-{{ $property->profit == 'plus' ? 'success' : 'danger' }}">
                                                    {{ $property->amount }}</p>
                                            </div>
                                        </td>
                                        <td data-label="@lang('Date')">
                                            <div>
                                                {{ date('d M Y', strtotime($property->created_at)) }}
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <!-- ============================ User Dashboard End ================================== -->
@endsection
@push('js')
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
     <script>
            $(document).ready(function() {
                $('input[name="looking_for"]').on('change', function() {
                    var lookingFor = $(this).val();
                    $.ajax({
                        url: '{{ route('user.dashboard.filter') }}',
                        type: 'GET',
                        data: { looking_for: lookingFor },
                        beforeSend: function() {
                        },
                        success: function(response) {
                            $('.data-container').html(response.html);
                        },
                        error: function(xhr) {
                            alert('No data found');
                        }
                    });
                });
            });
        </script>
    <script>
        'use strict';
        $(document).on('click', '#wishList', function() {
            let $this = $(this);
            let propertyId = $this.data('property');
            let userId = $this.data('user');

            if (!userId) {
                window.location.href = mainurl + '/login-register';
                return;
            }

            console.log("Wishlist Clicked!");

            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                method: "POST",
                url: mainurl + '/property/wishlist',
                data: {
                    property_id: propertyId,
                    user_id: userId
                },
                success: function(data) {
                    if (data.success) {
                        $this.removeClass().addClass('like-bitt add-to-favorite');
                        toastr.success(data.success);
                    } else {
                        $this.removeClass().addClass('add-to-favorite');
                        toastr.error(data.error);
                    }
                    setTimeout(() => {
                        location.reload();
                    }, 1000);
                }
            });
        });

        function myFunction() {
            var copyText = document.getElementById("cronjobURL");
            copyText.select();
            copyText.setSelectionRange(0, 99999);
            document.execCommand("copy");
            $.notify("Referral url copied", "info");
        }

        function toggleShareOptions(event, propertyId) {
            event.preventDefault();
            var shareOptions = document.getElementById('shareOptions-' + propertyId);
            shareOptions.style.display = (shareOptions.style.display === 'none' || shareOptions.style.display === '') ?
                'block' : 'none';
            setTimeout(function() {
                shareOptions.style.display = 'none';
            }, 2000);
        }

        function share(platform, url) {
            let text = "Check this out!";
            let shareUrl = "";
            switch (platform) {
                case 'facebook':
                    shareUrl = `https://www.facebook.com/sharer/sharer.php?u=${encodeURIComponent(url)}`;
                    break;
                case 'twitter':
                    shareUrl =
                        `https://twitter.com/intent/tweet?text=${encodeURIComponent(text)}&url=${encodeURIComponent(url)}`;
                    break;
                case 'instagram':
                    shareUrl = `https://www.instagram.com/?url=${encodeURIComponent(url)}`;
                    break;
                case 'linkedin':
                    shareUrl = `https://www.linkedin.com/sharing/share-offsite/?url=${encodeURIComponent(url)}`;
                    break;
                case 'whatsapp':
                    shareUrl = `https://wa.me/?text=${encodeURIComponent(text)}%20${encodeURIComponent(url)}`;
                    break;
                default:
                    console.log("Unsupported platform");
                    return;
            }
            if (shareUrl) {
                window.open(shareUrl, '_blank', 'noopener,noreferrer');
            }
        }

        function copyLink(url) {
            navigator.clipboard.writeText(url).then(function() {
                alert('Link copied to clipboard: ' + url);
            }, function(err) {
                console.error('Could not copy text: ', err);
            });
        }

        document.addEventListener("DOMContentLoaded", function() {
            document.querySelectorAll(".clickable-box").forEach(function(box) {
                box.addEventListener("click", function() {
                    let target = this.getAttribute("data-target");
                    document.querySelectorAll(".data-content").forEach(content => content.style
                        .display = "none");
                    document.getElementById(target).style.display = "block";
                });
            });
        });

        $(document).ready(function() {
            let recentSearches = JSON.parse(localStorage.getItem("recentSearches")) || [];
            console.log("Loaded recent searches:", recentSearches);

            let searchList = $("#recent-search-list");
            searchList.html("");

            if (recentSearches.length === 0) {
                searchList.append("<li>No recent searches found.</li>");
                $("#recent-searches-data").hide();
            } else {
                recentSearches.forEach((search, index) => {
                    let searchText = [];

                    // 1. Name
                    if (search.name) searchText.push(`<strong>${search.name}</strong>`);

                    // 2. City (get text from select dropdown if possible)
                    let cityName = '';
                    if (search.location_id) {
                        let cityOption = $('select[name="location_id"] option[value="' + search
                            .location_id + '"]');
                        if (cityOption.length) {
                            cityName = cityOption.text().trim();
                            searchText.push(`City: ${cityName}`);
                        }
                    }

                    // 3. Category
                    if (search.category_id) {
                        let catOption = $('select[name="category_id"] option[value="' + search.category_id +
                            '"]');
                        if (catOption.length) {
                            searchText.push(`Category: ${catOption.text().trim()}`);
                        }
                    }

                    // 4. BHK
                    if (search.no_of_bhk) searchText.push(`BHK: ${search.no_of_bhk}`);

                    // 5. Price
                    if (search.minPrice && search.maxPrice) {
                        searchText.push(
                            `Price: ₹${Number(search.minPrice).toLocaleString()} - ₹${Number(search.maxPrice).toLocaleString()}`
                        );
                    }

                    // 6. Sale Type
                    if (search.sale_type) searchText.push(`Sale Type: ${search.sale_type}`);

                    // 7. Construction Status
                    if (search.construction_status) searchText.push(
                        `Status: ${search.construction_status}`);

                    // Build URL
                    let searchParams = new URLSearchParams();
                    if (search.name) searchParams.append('name', search.name);
                    if (search.location_id) searchParams.append('location_id', search.location_id);
                    if (search.category_id) searchParams.append('category_id', search.category_id);
                    if (search.no_of_bhk) searchParams.append('no_of_bhk', search.no_of_bhk);
                    if (search.minPrice) searchParams.append('minPrice', search.minPrice);
                    if (search.maxPrice) searchParams.append('maxPrice', search.maxPrice);
                    if (search.sale_type) searchParams.append('sale_type', search.sale_type);
                    if (search.construction_status) searchParams.append('construction_status', search
                        .construction_status);
                    if (search.type) searchParams.append('type', search.type);
                    if (search.autoSubmit) searchParams.append('autoSubmit', search.autoSubmit);

                    // Append to UI
                    if (searchText.length > 0) {
                        searchList.append(`
                            <li class="d-flex justify-content-between align-items-center my-2">
                                <span>${searchText.join(" | ")}</span>
                                <a href="{{ url('listing') }}?${searchParams.toString()}" class="redo-search-icon" title="Search again">
                                    <i class="ti-search"></i>
                                </a>
                            </li>
                        `);
                    }
                });

                $("#recent-searches-data").show();
            }

            $("#clear-history").click(function() {
                localStorage.removeItem("recentSearches");
                searchList.html("<li>No recent searches found.</li>");
                $("#recent-searches-data").hide();
                console.log("Search history cleared!");
            });
        });

        document.addEventListener("DOMContentLoaded", function() {
            const lastShown = localStorage.getItem('verify_email_popup_last_shown');
            const now = Date.now();
            const oneHour = 60 * 60 * 1000;

            if (!lastShown || (now - lastShown) > oneHour) {
                $('#verifyEmailModal').modal('show');
                localStorage.setItem('verify_email_popup_last_shown', now);
            }
        });
    </script>
@endpush
